/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.entry;

import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import xaero.common.category.ui.GuiCategorySettings;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.entry.CategorySettingsListEntry;
import xaero.common.category.ui.entry.CategorySettingsListTextButtonEntry;
import xaero.common.category.ui.entry.ConnectionLineType;
import xaero.common.graphics.CursorBox;

public abstract class CategorySettingsListMainEntry<D extends GuiCategoryUIEditorExpandableData<?>>
extends CategorySettingsListEntry {
    private final ConnectionLineType lineType;
    protected final GuiCategoryUIEditorExpandableData<D> data;

    public CategorySettingsListMainEntry(int screenWidth, int index, GuiCategorySettings.SettingRowList rowList, ConnectionLineType lineType, GuiCategoryUIEditorExpandableData<D> data) {
        super(0, 0, screenWidth, 24, index, rowList, new Supplier<CursorBox>(){

            @Override
            public CursorBox get() {
                return null;
            }
        });
        this.lineType = lineType;
        this.data = data;
    }

    protected void addHelpElement(final Supplier<CursorBox> helpTooltipSupplier) {
        if (helpTooltipSupplier != null) {
            this.withSubEntry(new CenteredEntryFactory(){

                @Override
                public CategorySettingsListEntry get(int x, int y, int w, int h, CategorySettingsListMainEntry<?> root) {
                    return new CategorySettingsListTextButtonEntry(x - 24, y + 2, CategorySettingsListMainEntry.this.index, CategorySettingsListMainEntry.this.rowList, "?", -5592406, -1, 5, new Supplier<Boolean>(){

                        @Override
                        public Boolean get() {
                            return false;
                        }
                    }, CategorySettingsListMainEntry.this, helpTooltipSupplier);
                }
            });
        }
    }

    @Override
    public CategorySettingsListEntry render(int index, int rowWidth, int rowHeight, int relativeMouseX, int relativeMouseY, boolean isMouseOver, float partialTicks, FontRenderer font, int globalMouseX, int globalMouseY, boolean includesSelected, boolean isRoot) {
        CategorySettingsListEntry result = super.render(index, rowWidth, rowHeight, relativeMouseX, relativeMouseY, isMouseOver, partialTicks, font, globalMouseX, globalMouseY, includesSelected, isRoot);
        int xOffset = rowWidth / 2 - 110;
        int yOffset = 8;
        if (this.lineType == ConnectionLineType.TAIL_LEAF || this.lineType == ConnectionLineType.HEAD_LEAF) {
            int leftX = xOffset - 14;
            int rightX = xOffset - 2;
            int bottomY = yOffset + 4;
            int topY = yOffset - 24 + 4;
            this.func_73730_a(leftX, rightX, bottomY, -5592406);
            this.func_73728_b(leftX, topY, bottomY, -5592406);
            this.func_73728_b(rightX - 1, bottomY - 2, bottomY + 2, -5592406);
            this.func_73728_b(rightX - 2, bottomY - 3, bottomY + 3, -5592406);
            if (this.lineType == ConnectionLineType.HEAD_LEAF) {
                this.func_73730_a(leftX, rightX, topY, -5592406);
            }
        } else {
            int topY = yOffset - 24 + 9;
            int bottomY = yOffset - 2;
            int lineX = xOffset + 12;
            this.func_73730_a(lineX - 2, lineX + 2, bottomY - 3, -5592406);
            this.func_73730_a(lineX - 1, lineX + 1, bottomY - 2, -5592406);
            this.func_73728_b(lineX, topY, bottomY, -5592406);
        }
        return result;
    }

    public CategorySettingsListMainEntry<D> withSubEntry(CenteredEntryFactory entryFactory) {
        super.withSubEntry(entryFactory.get(this.rowList.func_148139_c() / 2 - 110 - 1, 0, 220, 24, this));
        return this;
    }

    @Override
    protected boolean selectAction() {
        return false;
    }

    @FunctionalInterface
    public static interface CenteredEntryFactory {
        public CategorySettingsListEntry get(int var1, int var2, int var3, int var4, CategorySettingsListMainEntry<?> var5);
    }
}

